﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Custom/EFR/Efr.Master" AutoEventWireup="true" CodeBehind="AdminEditReferenceRange.aspx.cs" Inherits="VIRP_WEB.Custom.EFR.Admin.AdminEditReferenceRange" %>
<%@ Import  Namespace="System.Web.Security.AntiXss" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" Runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" Runat="Server">
    <asp:FormView ID="FormViewReferenceRange" runat="server" 
        DataSourceID="ObjectDataSourceReferenceRange" DefaultMode="Edit">
        <EditItemTemplate>
            <table>
                <tr>
                    <td><asp:Label ID="LabelForTestName" runat="server" Text="Test Name" AssociatedControlID="LabelTestName" SkinID = "DataLabel"></asp:Label></td>
                    <td><asp:Label ID = "LabelTestName" runat = "server" Text = '<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("TestName")), false) %>' SkinID = "DataLabel"></asp:Label></td>
                </tr>
                <tr>
                    <td><asp:Label ID="LabelForAnalyteName" runat="server" Text="Analyte Name" AssociatedControlID="LabelAnalyteName" SkinID = "DataLabel"></asp:Label></td>
                    <td><asp:Label ID = "LabelAnalyteName" runat = "server" Text = '<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("AnalyteName")), false) %>' SkinID = "DataLabel"></asp:Label></td>
                </tr>
                <tr>
                    <td><asp:Label SkinID="DataLabel" ID="LabelTEFSCReferenceRange" runat="server" Text="TEFSC Reference Range" AssociatedControlID="TextBoxTEFSCReferenceRange"></asp:Label></td>
                    <td><asp:TextBox ID="TextBoxTEFSCReferenceRange" runat="server" Text='<%# Bind("TEFSCReferenceRange") %>' /></td>
                </tr>
                <tr>
                    <td><asp:Label SkinID="DataLabel" ID="LabelUnit" runat="server" Text="Unit" AssociatedControlID="DropDownListUnit"></asp:Label></td>
                    <td><asp:DropDownList SelectedValue='<%# Bind("UnitID") %>' ID="DropDownListUnit" runat="server" DataSourceID="ObjectDataSourceUnit" DataTextField="Name" DataValueField="ID" ></asp:DropDownList></td>
                </tr>
            </table>
            <asp:HiddenField ID="HiddenFieldID" runat="server" Value='<%# Bind("ID") %>' />
            <asp:HiddenField ID="HiddenFieldUnitName" runat="server" Value='<%# Bind("UnitName") %>' />

            <asp:Button ID="UpdateButton" runat="server" CausesValidation="True" 
                CommandName="Update" Text="Update" />
            &nbsp;<asp:Button OnClick="UpdateCancelButton_Click" ID="UpdateCancelButton" runat="server" 
                CausesValidation="False" CommandName="Cancel" Text="Cancel" />
        </EditItemTemplate>
    </asp:FormView>

    <asp:ObjectDataSource ID="ObjectDataSourceUnit" runat="server" 
        OldValuesParameterFormatString="original_{0}" 
        SelectMethod="GetBiomionitoringTestUnits" 
        TypeName="VIRP_WEB.BaseCode.EfrInterfaceManager" OnSelecting="ObjectDataSourceUnit_Selecting">
    </asp:ObjectDataSource>

    <asp:ObjectDataSource ID="ObjectDataSourceReferenceRange" runat="server" 
        DataObjectTypeName="VIRP.EFR.DAL.STD_ANALYTE_TEST_REFERENCE_RANGEDB+ReferenceRangeView" 
        OldValuesParameterFormatString="original_{0}" 
        SelectMethod="SelectReferenceRangeByID" 
        TypeName="VIRP.EFR.DAL.STD_ANALYTE_TEST_REFERENCE_RANGEDB" 
        UpdateMethod="UpdateReferenceRange" 
        onupdated="ObjectDataSourceReferenceRange_Updated">
        <SelectParameters>
            <asp:QueryStringParameter DefaultValue="0" Name="ID" QueryStringField="ID" 
                Type="Int32" />
        </SelectParameters>
    </asp:ObjectDataSource>

</asp:Content>

